﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Libraries
{
    public enum TipoIcono { aviso, campana, descarga };


    public class Alertas
    {
        static string HtmlArbolApertura = "";

        //icon-warning-sign
        //    icon-bell
        //        icon-download
        internal static void Show(ViewDataDictionary ViewData, string controlador,string accion, TipoIcono tipoicono, string mensaje, string numero, string idLi)
        {

            //Inicia los valores por default
            //
            string icono = "";
            ViewData["HtmlAlertas"] = "";
            string alerta = null;
            alerta = "<li class='dropdown' id='" + idLi + "'>";
            alerta = alerta + "<a href='" + controlador + "/" + accion + "' class='dropdown-toggle'><i class= ";
            switch (tipoicono)
            {
                case TipoIcono.aviso:
                    icono = "'icon-warning-sign'";
                    break;
                case TipoIcono.campana:
                    icono = "'icon-bell'";
                    break;
                case TipoIcono.descarga:

                    icono = "'icon-download'";
                    break;
                default:
                    icono = "'icon-warning-sign'";
                    break;
            }
            alerta = alerta + icono + " > </i><span class='badge'>" + numero + "</span></a></li>";

            ViewData["HtmlAlertas"] = alerta;
        }
        internal static void ShowEstructuraOrganica(ViewDataDictionary ViewData)
        {

            //Inicia los valores por default
            //
            //HtmlArbolApertura = "<ul id='tree_1' class='tree'>";
            HtmlArbolApertura = "";

            HttpContext.Current.Session["Estructura"] = null;
            ViewData["HtmlEsgtructura"] = "";
            LlenarArbol("0");
            ViewData["HtmlEsgtructura"] = HtmlArbolApertura ;
        }

        private static void LlenarArbol(string padre)
        {
            if (padre == "0")
            {
                HtmlArbolApertura = HtmlArbolApertura + "<ul>";
            }
            else
            {
                HtmlArbolApertura = HtmlArbolApertura + "<ul>";

            }
            HtmlArbolApertura = HtmlArbolApertura + "<li >";

            bdNovaEntities db = new bdNovaEntities();
            if (HttpContext.Current.Session["Estructura"] == null)
            {
                List<Estructura> ListaEstructura = new List<Estructura>();

                var estructura = from a in db.Catalogos_ctEstructuraOrganica
                                 orderby a.IdEstructuraOrganica, a.IdEstructuraOrganicaPadre
                                 select new { Id = a.IdEstructuraOrganica, ParentId = a.IdEstructuraOrganicaPadre, Estructura = a.EstructuraOrganica };

                foreach (var i in estructura)
                {
                    Estructura e = new Estructura();
                    e.Id = i.Id.ToString();
                    e.ParentId = i.ParentId.ToString();
                    e.Nombre = i.Estructura;
                    ListaEstructura.Add(e);
                }
                HttpContext.Current.Session["Estructura"] = ListaEstructura;
            }
            var est = (List<Estructura>)HttpContext.Current.Session["Estructura"];
            string indicador = "0";
            if (padre == "0")
            {
                indicador = "1";
            }
            else
            {
                indicador =padre;
            }
            var indice = est.Find(i => i.Id == indicador);
            if (indice != null)
            {
                HtmlArbolApertura = HtmlArbolApertura + "<a>" + "<input type='radio' name='area' value='" + indice.Id + "'>" + indice.Nombre + "</a>";

            }

            var hijos = from a in est
                        where a.ParentId == indice.Id
                        select new { Id = a.Id, ParentId = a.ParentId, Estructura = a.Nombre };
           if (hijos != null)
           {
               foreach (var item in hijos)
               {
                   //HtmlArbolApertura = HtmlArbolApertura + "<li>";
                   //HtmlArbolApertura = HtmlArbolApertura + "<a href='#' data-role='branch' class='tree-toggle' data-toggle='branch'>" + item.Estructura + "</a>";
                   LlenarArbol(item.Id);

               }

           }
            HtmlArbolApertura = HtmlArbolApertura + "</li>";
            HtmlArbolApertura = HtmlArbolApertura + "</ul>";
        }
        internal static void ShowEstructuraOrganicaChk(ViewDataDictionary ViewData)
        {

            //Inicia los valores por default
            //
            //HtmlArbolApertura = "<ul id='tree_1' class='tree'>";
            HtmlArbolApertura = "";

            HttpContext.Current.Session["Estructura"] = null;
            ViewData["HtmlEstructuraChk"] = "";
            LlenarArbolChk("0");
            ViewData["HtmlEstructuraChk"] = HtmlArbolApertura;
        }

        private static void LlenarArbolChk(string padre)
        {
            if (padre == "0")
            {
                HtmlArbolApertura = HtmlArbolApertura + "<ul>";
            }
            else
            {
                HtmlArbolApertura = HtmlArbolApertura + "<ul>";

            }
            HtmlArbolApertura = HtmlArbolApertura + "<li >";

            bdNovaEntities db = new bdNovaEntities();
            if (HttpContext.Current.Session["Estructura"] == null)
            {
                List<Estructura> ListaEstructura = new List<Estructura>();

                var estructura = from a in db.Catalogos_ctEstructuraOrganica
                                 orderby a.IdEstructuraOrganica, a.IdEstructuraOrganicaPadre
                                 select new { Id = a.IdEstructuraOrganica, ParentId = a.IdEstructuraOrganicaPadre, Estructura = a.EstructuraOrganica };

                foreach (var i in estructura)
                {
                    Estructura e = new Estructura();
                    e.Id = i.Id.ToString();
                    e.ParentId = i.ParentId.ToString();
                    e.Nombre = i.Estructura;
                    ListaEstructura.Add(e);
                }
                HttpContext.Current.Session["Estructura"] = ListaEstructura;
            }
            var est = (List<Estructura>)HttpContext.Current.Session["Estructura"];
            string indicador = "0";
            if (padre == "0")
            {
                indicador = "1";
            }
            else
            {
                indicador = padre;
            }
            var indice = est.Find(i => i.Id == indicador);
            if (indice != null)
            {
                HtmlArbolApertura = HtmlArbolApertura + "<a>" + "<input type='checkbox' name='Area_"+indice.Id+"' value='" + indice.Id + "'>" + indice.Nombre + "</a>";

            }

            var hijos = from a in est
                        where a.ParentId == indice.Id
                        select new { Id = a.Id, ParentId = a.ParentId, Estructura = a.Nombre };
            if (hijos != null)
            {
                foreach (var item in hijos)
                {
                    //HtmlArbolApertura = HtmlArbolApertura + "<li>";
                    //HtmlArbolApertura = HtmlArbolApertura + "<a href='#' data-role='branch' class='tree-toggle' data-toggle='branch'>" + item.Estructura + "</a>";
                    LlenarArbolChk(item.Id);

                }

            }
            HtmlArbolApertura = HtmlArbolApertura + "</li>";
            HtmlArbolApertura = HtmlArbolApertura + "</ul>";
        }

    }
}
